import { formatDistance } from "./be-tarask/_lib/formatDistance.js";
import { formatLong } from "./be-tarask/_lib/formatLong.js";
import { formatRelative } from "./be-tarask/_lib/formatRelative.js";
import { localize } from "./be-tarask/_lib/localize.js";
import { match } from "./be-tarask/_lib/match.js";

/**
 * @category Locales
 * @summary Belarusian Classic locale.
 * @language Belarusian Classic
 * @iso-639-2 bel
 * @author Ryhor Nopears [@nopears](https://github.com/nopears)
 */
export const beTarask = {
  code: "be-tarask",
  formatDistance: formatDistance,
  formatLong: formatLong,
  formatRelative: formatRelative,
  localize: localize,
  match: match,
  options: {
    weekStartsOn: 1 /* Monday */,
    firstWeekContainsDate: 1,
  },
};

// Fallback for modularized imports:
export default beTarask;
