"use strict";
exports.endOfQuarter = endOfQuarter;
var _index = require("./toDate.cjs");

var _index2 = require("./_core/getMonth.cjs");
var _index3 = require("./_core/setMonth.cjs");

/**
 * The {@link endOfQuarter} function options.
 */

/**
 * @name endOfQuarter
 * @category Quarter Helpers
 * @summary Return the end of a year quarter for the given date.
 *
 * @description
 * Return the end of a year quarter for the given date.
 * The result will be in the local timezone.
 *
 * @typeParam DateType - The `Date` type, the function operates on. Gets inferred from passed arguments. Allows to use extensions like [`UTCDate`](https://github.com/date-fns/utc).
 * @typeParam ResultDate - The result `Date` type, it is the type returned from the context function if it is passed, or inferred from the arguments.
 *
 * @param date - The original date
 * @param options - An object with options
 *
 * @returns The end of a quarter
 *
 * @example
 * // The end of a quarter for 2 September 2014 11:55:00:
 * const result = endOfQuarter(new Date(2014, 8, 2, 11, 55, 0))
 * //=> Tue Sep 30 2014 23:59:59.999
 */
function endOfQuarter(date, options) {
  const _date = (0, _index.toDate)(date, options?.in);
  const currentMonth = (0, _index2.getMonth)(_date);
  const month = currentMonth - (currentMonth % 3) + 3;
  (0, _index3.setMonth)(_date, month, 0);
  _date.setHours(23, 59, 59, 999);
  return _date;
}
