# 🚀 FiveM UDG V5.0 - cPanel Installation Guide

## 📋 Prerequisites
- cPanel hosting with Node.js support
- SSL Certificate (required for Supabase)
- Minimum 512MB RAM
- Supabase account

## 🔧 Step-by-Step Installation

### 1. **Prepare Files**
```bash
# Run build script
node deploy.js
```

### 2. **Upload to cPanel**
- Compress entire project folder
- Upload via File Manager to public_html
- Extract files

### 3. **Setup Node.js App**
- Go to "Node.js Apps" in cPanel
- Create New App:
  - App Root: `/public_html/your-folder`
  - App URL: `your-domain.com`
  - App Startup File: `server.js`
  - Node.js Version: 18+ (recommended)

### 4. **Install Dependencies**
```bash
# In cPanel Terminal or SSH
cd public_html/your-folder
npm install --production
```

### 5. **Environment Variables**
Add in Node.js App environment:
```
NEXT_PUBLIC_SUPABASE_URL=your_supabase_url
NEXT_PUBLIC_SUPABASE_ANON_KEY=your_anon_key
NODE_ENV=production
```

### 6. **Database Setup**
- Create Supabase project
- Run SQL scripts from `/scripts/` folder
- Enable Row Level Security

### 7. **Start Application**
- Click "Restart" in Node.js Apps
- Visit your domain

## 🔍 Troubleshooting

### Common Issues:
1. **Port Error**: Use process.env.PORT in server.js
2. **SSL Required**: Enable SSL certificate
3. **Memory Limit**: Increase Node.js memory limit
4. **Build Errors**: Run `npm run build` locally first

### Support:
- Discord: discord.gg/A3dEYdqnyK
- Check logs in cPanel Error Logs

## ✅ Verification
- [ ] Node.js app running
- [ ] SSL certificate active
- [ ] Environment variables set
- [ ] Database connected
- [ ] Domain accessible